using System;
using System.Data;
using Borland.Eco.Persistence;
using Borland.Eco.Persistence.Default;
using Borland.Eco.Persistence.Configuration;

namespace Ecoyee
{
	// the OnHold attribute is mapped to a char, and null is false, "*" is true
	public class OnHoldBooleanAsCharMapper: AbstractSingleColumnAttribute, ISingleColumnAttributemapping, INonBooleanBooleanMapping
	{
		public String ColumnType(int length)
		{
			return "CHAR(1)"; // do not localize
		}

		public String DefaultDbValue(string modeledValue, SqlDatabaseConfig sqlDatabaseConfig)
		{
			if ((modeledValue == null) || (modeledValue.Length == 0))
				return null; // do not localize
			else
				return modeledValue;
		}

		public void ValueToParameter(System.Object value, IDataParameter parameter)
		{
			parameter.DbType = DbType.String;
			if (value == null)
				parameter.Value = DBNull.Value;
			else if ((bool)value == true)
				parameter.Value = TrueString;
			else
				parameter.Value = DBNull.Value;
		}

		public void StringToParameter(string value, IDataParameter parameter)
		{
			ValueToParameter(MappingUtils.ConvertStringToBoolean(value), parameter);
		}


		public override System.Object ColumnToValue(System.Object columnValue)
		{
			if (columnValue == DBNull.Value)
				return null;
			else if ((System.String)columnValue == TrueString)
				return true;
			else
				return false;
		}

		public string TrueString
		{
			get { return "*"; }
		}
	}
}
